/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.pay.core.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.service.schema.util.StringUtil;
import com.zbkj.pay.core.BasePay;
import com.zbkj.pay.core.config.MerConfig;
import com.zbkj.pay.core.enums.ServerTypeEnum;
import com.zbkj.pay.core.exception.BasePayException;
import com.zbkj.pay.core.exception.FailureCode;
import com.zbkj.pay.core.net.AbstractRequest;
import com.zbkj.pay.core.sign.JsonUtils;
import com.zbkj.pay.core.utils.HttpClientUtils;
import com.zbkj.pay.core.utils.RsaUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractRequest {
    public static final String SDK_VERSION = "1.0.0";

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, MerConfig config, boolean isPage) throws BasePayException {
        return AbstractRequest.requestBasePayCore((RequestMethod)method, (String)uri, params, (File)null, (String)null, (MerConfig)config, (ServerTypeEnum)null, (boolean)isPage);
    }

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, MerConfig config, ServerTypeEnum serverType, boolean isPage) throws BasePayException {
        return AbstractRequest.requestBasePayCore((RequestMethod)method, (String)uri, params, (File)null, (String)null, (MerConfig)config, (ServerTypeEnum)serverType, (boolean)isPage);
    }

    public static String getUrl() {
        String baseUrl;
        switch (BasePay.prodMode) {
            case "test": {
                baseUrl = "https://opps-stbmertest.testpnr.com";
                break;
            }
            case "inner_test": {
                baseUrl = "https://spin-test.cloudpnr.com";
                break;
            }
            default: {
                baseUrl = "https://www.yunshi-life.com/v1";
            }
        }
        return baseUrl;
    }

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, File file, String fileParam, MerConfig config, ServerTypeEnum serverType, boolean isPage) throws BasePayException {
        String requestSign;
        String baseUrl = AbstractRequest.getUrl();
        if (ServerTypeEnum.PAGE.equals((Object)serverType)) {
            baseUrl = AbstractRequest.getUrl();
        }
        if (params != null && params.get("base_url") != null) {
            baseUrl = (String)params.get("base_url");
            params.remove("base_url");
        }
        StringBuilder requestUrl = new StringBuilder(baseUrl);
        if (!baseUrl.endsWith("/")) {
            requestUrl.append("/");
        }
        requestUrl.append(uri);
        String back = null;
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("sdk_version", "javaSDK_1.0.0");
        String reqData = JSONObject.toJSONString(params);
        String privateKey = config.getRsaPrivateKey();
        if (BasePay.debug) {
            System.out.println("PRIVATE_KEY=" + privateKey);
        }
        try {
            String sortedData = JsonUtils.sort4JsonString((String)reqData, (int)0);
            requestSign = RsaUtils.sign((String)sortedData, (String)privateKey);
        }
        catch (Exception var24) {
            Exception e = var24;
            if (BasePay.debug) {
                e.printStackTrace();
            }
            requestSign = null;
        }
        if (requestSign != null && requestSign.length() != 0) {
            if (BasePay.debug) {
                System.out.println("request sign=" + requestSign);
            }
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("data", JSONObject.parseObject((String)reqData));
            request.put("sign", requestSign);
            request.put("sys_id", config.getSysId());
            String requestBody = JSON.toJSONString(request);
            if (BasePay.debug) {
                System.out.println("request data = " + JSONObject.parseObject((String)reqData));
                System.out.println("requestBody param = " + requestBody);
            }
            if (RequestMethod.POST == method && file == null) {
                headers.put("Content-type", "application/json");
                back = HttpClientUtils.httpPostJson((String)requestUrl.toString(), headers, (String)requestBody);
            } else if (RequestMethod.POST == method && file != null) {
                back = HttpClientUtils.httpPostFile((String)requestUrl.toString(), headers, request, (File)file, (String)fileParam);
            } else if (RequestMethod.GET == method) {
                back = HttpClientUtils.httpGet((String)requestUrl.toString(), headers, params);
            }
            if (BasePay.debug) {
                System.out.println("response string=" + back);
            }
            if (back != null && back.length() != 0) {
                boolean checkSign;
                if (BasePay.debug) {
                    System.out.println("Is a version of the page=" + isPage);
                }
                if (isPage) {
                    JSONObject jo = new JSONObject();
                    jo.put("data", (Object)back);
                    return jo;
                }
                JSONObject jo = JSON.parseObject((String)back);
                JSONObject data = jo.getJSONObject("data");
                String sign = jo.getString("sign");
                String publicKey = config.getRsaPublicKey();
                if (StringUtil.isEmpty((String)publicKey)) {
                    publicKey = BasePay.HUIFU_DEFAULT_PUBLIC_KEY;
                }
                if (BasePay.debug) {
                    System.out.println("PUBLIC_KEY=" + publicKey);
                    System.out.println("response data=" + data);
                    System.out.println("response sign:" + sign);
                }
                try {
                    String sortedData = JsonUtils.sort4JsonString((String)JSONObject.toJSONString((Object)data), (int)5);
                    checkSign = RsaUtils.verify((String)sortedData, (String)publicKey, (String)sign);
                }
                catch (Exception var23) {
                    Exception e = var23;
                    if (BasePay.debug) {
                        e.printStackTrace();
                    }
                    checkSign = false;
                }
                if (!checkSign) {
                    if (BasePay.debug) {
                        System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                    }
                    throw new BasePayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Response sign check error. Please check your pubkey.");
                }
                return data;
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Request no response. Please check your network.");
        }
        throw new BasePayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Sign error. Please check your privateKey.");
    }

    public static String getOriginalStr(Map<String, Object> map) {
        ArrayList<String> listKeys = new ArrayList<String>(map.keySet());
        Collections.sort(listKeys);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < listKeys.size(); ++i) {
            if (map.get(listKeys.get(i)) == null || map.get(listKeys.get(i)).toString().length() == 0) continue;
            stringBuilder.append((String)listKeys.get(i)).append("=").append(map.get(listKeys.get(i))).append("&");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }
}

