/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.pay.core.utils;

import com.alibaba.fastjson.JSON;
import com.zbkj.pay.core.BasePay;
import com.zbkj.pay.core.config.MerConfig;
import com.zbkj.pay.core.exception.BasePayException;
import com.zbkj.pay.core.exception.FailureCode;
import com.zbkj.pay.core.utils.HttpClientUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientUtils {
    private static CloseableHttpClient httpClient;
    private static RequestConfig requestConfig;
    private static int connectionRequestTimeout;
    private static int socketTimeout;
    private static int connectTimout;
    private static final ReentrantLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String url) {
        URL aUrl = null;
        try {
            aUrl = new URL(url);
        }
        catch (Exception var8) {
            return null;
        }
        int port = "https".equals(aUrl.getProtocol()) ? (aUrl.getPort() == -1 ? 443 : aUrl.getPort()) : (aUrl.getPort() == -1 ? 80 : aUrl.getPort());
        String hostname = aUrl.getHost();
        if (httpClient == null) {
            lock.lock();
            try {
                if (httpClient == null) {
                    httpClient = HttpClientUtils.createHttpClient((int)500, (int)40, (int)100, (String)hostname, (int)port);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLContext sslcontext = SSLContexts.createDefault();
        TrustManager[] trustAllCerts = new TrustManager[1];
        X509TrustManager tm = HttpClientUtils.getX509TrustManager();
        trustAllCerts[0] = tm;
        try {
            sslcontext.init(null, trustAllCerts, null);
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        1 hostnameVerifier = new /* Unavailable Anonymous Inner Class!! */;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry, null, (SchemePortResolver)null, (DnsResolver)null, 5L, TimeUnit.MINUTES);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        2 httpRequestRetryHandler = new /* Unavailable Anonymous Inner Class!! */;
        if (requestConfig == null) {
            HttpClientUtils.initRequestConfig();
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)httpRequestRetryHandler).build();
        HttpClientUtils.closeExpiredConnectionsPeriodTask((int)1, (PoolingHttpClientConnectionManager)cm);
        return httpClient;
    }

    public static X509TrustManager getX509TrustManager() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static void closeExpiredConnectionsPeriodTask(int timeUnitBySecond, PoolingHttpClientConnectionManager cm) {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        executorService.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, 10L, timeUnitBySecond, TimeUnit.MINUTES);
    }

    static void initRequestConfig() {
        requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    public static String httpPost(String url, Map<String, Object> params, boolean isJson) throws BasePayException {
        return HttpClientUtils.httpPost((String)url, (Map)null, params, (boolean)false, (String)null, (boolean)isJson, (File)null, (String)null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpPost((String)url, headers, params, (boolean)false, (String)null, (boolean)false, (File)null, (String)null);
    }

    public static String httpPostJson(String url, Map<String, String> headers, String json) throws BasePayException {
        return HttpClientUtils.httpPost((String)url, headers, (Map)null, (boolean)false, (String)json, (boolean)true, (File)null, (String)null);
    }

    public static String httpPostFile(String url, Map<String, String> headers, Map<String, Object> params, File file, String fileParam) throws BasePayException {
        return HttpClientUtils.httpPost((String)url, headers, params, (boolean)false, (String)null, (boolean)false, (File)file, (String)fileParam);
    }

    public static String httpPostNoFile(String url, Map<String, String> headers, Map<String, Object> params, File file, String fileParam) throws BasePayException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            if (BasePay.debug) {
                System.out.println("request headers=" + JSON.toJSONString(headers));
                System.out.println("request url = " + url);
                System.out.println("request param = " + null);
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("UTF-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            builder.addTextBody(entry.getKey(), entry.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED.withCharset("utf-8"));
        }
        httpPost.setEntity(builder.build());
        return HttpClientUtils.getResult((HttpRequestBase)httpPost, (String)url, (boolean)false);
    }

    public static String httpPost(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, String json, boolean isJson) throws BasePayException {
        return HttpClientUtils.httpPost((String)url, (Map)null, params, (boolean)false, (String)json, (boolean)isJson, (File)null, (String)null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params, boolean isStream, String json, boolean isJson, File file, String fileParam) throws BasePayException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            if (BasePay.debug) {
                System.out.println("request headers=" + JSON.toJSONString(headers));
                System.out.println("request url = " + url);
                System.out.println("request param = " + json);
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (file != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart(fileParam, (ContentBody)new FileBody(file));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addTextBody(entry.getKey(), entry.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED.withCharset("utf-8"));
            }
            httpPost.setEntity(builder.build());
        }
        if (file == null && null != params) {
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.covertParams2NVPS(params), "UTF-8"));
            }
            catch (UnsupportedEncodingException var12) {
                UnsupportedEncodingException e = var12;
                if (BasePay.debug) {
                    e.printStackTrace();
                }
                throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
            }
        }
        if (isJson && json != null && json.length() != 0) {
            StringEntity entity = new StringEntity(json, "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpPost, (String)url, (boolean)isStream);
    }

    public static String httpGet(String url, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpGet((String)url, (Map)null, params, (int)10000, (int)30000, (int)30000, (boolean)false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpGet((String)url, headers, params, (int)10000, (int)30000, (int)30000, (boolean)false);
    }

    public static String httpGet(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout) throws BasePayException {
        return HttpClientUtils.httpGet((String)url, (Map)null, params, (int)connectionRequestTimeout, (int)connectTimeout, (int)socketTimeout, (boolean)false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean isStream) throws BasePayException {
        HttpGet httpGet;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException var12) {
            URISyntaxException e = var12;
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != params) {
            uriBuilder.setParameters(HttpClientUtils.covertParams2NVPS(params));
        }
        try {
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (Exception var11) {
            Exception e = var11;
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpGet, (String)url, (boolean)isStream);
    }

    private static String getResult(HttpRequestBase httpRequest, String url, boolean isStream) throws BasePayException {
        String var31;
        StringBuilder sb = new StringBuilder();
        CloseableHttpResponse response = null;
        BufferedReader br = null;
        CloseableHttpClient httpClient = null;
        try {
            if (!BasePay.userDefaultCloseableHttpClient) {
                httpClient = HttpClientUtils.getHttpClient((String)url);
            } else {
                httpClient = HttpClients.createDefault();
                MerConfig merConfig = BasePay.getConfig((String)"default");
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).build();
                httpRequest.setConfig(requestConfig);
            }
            response = httpClient.execute((HttpUriRequest)httpRequest);
            int respCode = response.getStatusLine().getStatusCode();
            if (BasePay.debug) {
                System.out.println("response code = " + respCode);
            }
            if (200 == respCode) {
                HttpEntity entity = response.getEntity();
                if (isStream) {
                    String len;
                    br = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                    while ((len = br.readLine()) != null) {
                        sb.append(len);
                    }
                } else {
                    sb.append(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                }
            } else {
                sb.append(response.getEntity() == null ? "" : EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            var31 = sb.toString();
        }
        catch (SocketTimeoutException | ConnectTimeoutException var24) {
            Throwable e = var24;
            if (BasePay.debug) {
                e.printStackTrace();
            }
            if (e instanceof SocketTimeoutException) {
                throw new BasePayException(FailureCode.SOCKET_TIME_EXCEPTION.getFailureCode(), "post request  fail, socket timeout exception.");
            }
            throw new BasePayException(FailureCode.CONNECT_EXCEPTION.getFailureCode(), "post request fail, connection timeout.");
        }
        catch (IOException | UnsupportedOperationException | ParseException var25) {
            Throwable e = var25;
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION, e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException var23) {
                    IOException ioe = var23;
                    if (BasePay.debug) {
                        ioe.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException var21) {
                    IOException ioe = var21;
                    if (BasePay.debug) {
                        ioe.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
            if (BasePay.userDefaultCloseableHttpClient && null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException var22) {
                    IOException ioe = var22;
                    if (BasePay.debug) {
                        ioe.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
        }
        return var31;
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        LinkedList<NameValuePair> paramList = new LinkedList<NameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), null == entry.getValue() ? "" : entry.getValue().toString()));
        }
        return paramList;
    }

    static {
        connectionRequestTimeout = 30000;
        socketTimeout = 20000;
        connectTimout = 20000;
        lock = new ReentrantLock();
    }
}

